% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leMsMs.r
\name{problematicPeaks}
\alias{problematicPeaks}
\title{Identify intense peaks (in a list of unmatched peaks)}
\usage{
problematicPeaks(sp)
}
\arguments{
\item{sp}{a RmbSpectrum2 object to be checked for problematic peaks.}
}
\value{
The modified RmbSpectrum2 object with additional columns/properties 
 `problematicPeaks` (logical `TRUE` if the peak is intense and unannotated),
 `aMax` (base peak intensity), `mzCenter` (the precursor m/z).
}
\description{
Finds a list of peaks in spectra with a high relative intensity (>10% and
1e4, or >1% and 1e5) to write a list of peaks which must be manually
checked.  Peaks orbiting around the parent peak mass (calculated from the
compound ID), which are very likely co-isolated substances, are ignored.
}
\note{
TODO: there is hardcoded logic in this function that needs to be
 resolved eventually!
}
\examples{
# As used in the workflow: 

sp <- new("RmbSpectrum2", mz = c(100,200,300,400,500), intensity = c(999999,888888,777777,666666,555555))
sp@ok <- TRUE
property(sp, "mzFound", addNew=TRUE) <- sp@mz
sp@good <- c(TRUE, TRUE, TRUE, FALSE, FALSE)
sp@precursorMz <- 600
sp_checked <- problematicPeaks(sp)
# stopifnot(sum(getData(sp_checked)$problematicPeak) == 2)
}
\seealso{
\code{\link{msmsWorkflow}}
}
\author{
Michael Stravs
}
