% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeSpectra.R
\name{mergePeaks}
\alias{mergePeaks}
\alias{mergePeaks,data.frame-method}
\alias{mergePeaks,matrix-method}
\alias{mergePeaks,RmbSpectrum2-method}
\alias{mergePeaks,Spectrum-method}
\title{Merge peaks for spectra merging, FT shoulder elimination etc.}
\usage{
mergePeaks(peaks, ...)

\S4method{mergePeaks}{data.frame}(peaks, ...)

\S4method{mergePeaks}{matrix}(peaks, ...)

\S4method{mergePeaks}{RmbSpectrum2}(peaks, ...)

\S4method{mergePeaks}{Spectrum}(peaks, ...)
}
\arguments{
\item{peaks}{data.frame, matrix or RmbSpectrum2
The peak-table to be merged. In case of an \code{RmbSpectrum2}-object,
peaks are retrieved and updated via \code{\link{getData}}
and \code{\link{setData}}, respectively}

\item{...}{3 numeric values
These define cutoff limits (see details)}
}
\value{
object of the same class as peaks
The result contains a reduced peak-table ordered by m/z
}
\description{
This procedure first sorts peaks by intensity (descending sort)
and then starts iterating over the peaks, removing all entries
that deviate "sufficiently far" from the currently selected peak.
See the Details section for a full explanation and information on
how to fine-tune peak removal.
}
\details{
Three parameters must be passed to \code{mergePeaks} for
peak-removal control in this order:
- cutoff_dppm_limit
- cutoff_absolute_limit
- cutoff_intensity_limit
The method iterates through the peaks, beginning with the
highest-intensity peak and in each step removes all other
peaks that fulfill conditions 1 AND 2 relative to the selected peak
1. Their m/z value does not deviate too far from the one of the selected peak.
i.e. if the selected peak is p and the checked peak is c, it holds that
EITHER
|p$mz - c$mz| <= cutoff_absolute_limit
OR
|p$mz - c$mz| <= ppm(p$mz, cutoff_dppm_limit, p=TRUE)
(see \code{\link{ppm}})
2. Their intensity is much smaller than the one of the selected peak, i.e.
c$mz < cutoff_intensity_limit * p$mz
for a suitable cutoff_intensity_limit between 0 and 1.
}
\examples{
\dontrun{mergePeaks(spectrum, 10, 0.5, 0.05)}
}
\seealso{
\code{\link{getData}}, \code{\link{setData}}, \code{\link{ppm}}
}
