% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webAccess.R
\name{getCSID}
\alias{getCSID}
\title{Retrieve the Chemspider ID for a given compound}
\usage{
getCSID(query)
}
\arguments{
\item{query}{The InChIKey of the compound}
}
\value{
Returns the chemspide
}
\description{
Given an InChIKey, this function queries the chemspider web API to retrieve
the Chemspider ID of he compound with that InChIkey.
}
\examples{

\dontrun{
# Return all CAS registry numbers stored for benzene.
data <- getCtsRecord("UHOVQNZJYSORNB-UHFFFAOYSA-N")
cas <- CTS.externalIdSubset(data, "CAS")
} 

}
\author{
Michele Stravs, Eawag <stravsmi@eawag.ch>

Erik Mueller, UFZ <erik.mueller@ufz.de>
}
