% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leCsvAccess.R
\name{findMz.formula}
\alias{findMz.formula}
\title{Find the exact mass +/- a given margin for a given formula or its ions and adducts.}
\usage{
findMz.formula(formula, mode = "pH", ppm = 10, deltaMz = 0)
}
\arguments{
\item{formula}{The molecular formula  in text or list format (see \code{\link{formulastring.to.list}}}

\item{mode}{\code{"pH", "pNa", "pM", "pNH4", "mH", "mM", "mFA"} for different ions 
([M+H]+, [M+Na]+, [M]+, [M+NH4]+, [M-H]-, [M]-, [M+FA]-). "" for the uncharged molecule.}

\item{ppm}{The ppm margin to add/subtract}

\item{deltaMz}{The absolute mass to add/subtract. Cumulative with \code{ppm}}
}
\value{
A \code{list(mzMin=, mzCenter=, mzMax=)} with the masses.
}
\description{
Find the exact mass +/- a given margin for a given formula or its ions and adducts.
}
\examples{
findMz.formula("C6H6")
}
\seealso{
\code{\link{findMz}}
}
\author{
Michael A. Stravs, Eawag <michael.stravs@eawag.ch>
}
