% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leCsvAccess.R
\name{findMz}
\alias{findMz}
\alias{findSmiles}
\alias{findFormula}
\alias{findRt}
\alias{findCAS}
\alias{findName}
\alias{findLevel}
\title{Find compound information}
\usage{
findMz(cpdID, mode = "pH", ppm = 10, deltaMz = 0, retrieval="standard",
unknownMass = getOption("RMassBank")$unknownMass )

findRt(cpdID) 

findSmiles(cpdID) 

findFormula(cpdID, retrieval="standard") 

findCAS(cpdID)

findName(cpdID)

findLevel(cpdID, compact=FALSE)
}
\arguments{
\item{cpdID}{The compound ID in the compound list.}

\item{mode}{Specifies the species of the molecule: An empty string specifies
uncharged monoisotopic mass, \code{\var{pH}} (positive H) specifies [M+H]+,
\code{\var{pNa}} specifies [M+Na]+, \code{\var{pM}} specifies [M]+,
\code{\var{mH}} and \code{\var{mFA}} specify [M-H]- and [M+FA]-,
respectively. (I apologize for the naming of \code{\var{pH}} which has
absolutely nothing to do with chemical \emph{pH} values.)}

\item{ppm}{Specifies ppm window (10 ppm will return the range of the
molecular mass + and - 10 ppm).}

\item{deltaMz}{Specifies additional m/z window to add to the range (deltaMz
= 0.02 will return the range of the molecular mass +- 0.02 (and additionally
+- the set ppm value).}

\item{retrieval}{A value that determines whether the files should be handled either as "standard",
if the compoundlist is complete, "tentative", if at least a formula is present or "unknown"
if the only know thing is the m/z}

\item{unknownMass}{`charged` or `neutral` (`charged` assumed by default) specifies
whether a mass of an unknown compound (level 5) refers to the charged or neutral mass
(and correspondingly, whether it must be shifted or not to find the m/z value)}

\item{compact}{Only for \code{findLevel}, returns the "retrieval" parameter used for many functions 
within RMassBank if TRUE}
}
\value{
\code{findMz} will return a \code{list(mzCenter=, mzMin=, mzMax=)}
with the molecular weight of the given ion, as calculated from the SMILES
code and Rcdk.

\code{findRt}, \code{findSmiles},\code{findCAS},\code{findName} will return
the corresponding entry from the compound list. \code{findFormula} returns
the molecular formula as determined from the SMILES code.
}
\description{
Retrieves compound information from the loaded compound list or calculates
it from the SMILES code in the list.
}
\examples{

\dontrun{\%
	findMz(123, "pH", 5)
	findFormula(123)
}

}
\seealso{
\code{\link{findMass}}, \code{\link{loadList}}, \code{\link{findMz.formula}}
}
\author{
Michael Stravs
}
