% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leMsmsRaw.R
\name{findMsMsHRperxcms}
\alias{findMsMsHRperxcms}
\alias{findMsMsHRperxcms.direct}
\title{Read in mz-files using XCMS}
\usage{
findMsMsHRperxcms(
  fileName,
  cpdID,
  mode = "pH",
  findPeaksArgs = NULL,
  plots = FALSE,
  MSe = FALSE
)

findMsMsHRperxcms.direct(
  fileName,
  cpdID,
  mode = "pH",
  findPeaksArgs = NULL,
  plots = FALSE,
  MSe = FALSE
)
}
\arguments{
\item{fileName}{The path to the mz-file that should be read}

\item{cpdID}{The compoundID(s) of the compound that has been used for the file}

\item{mode}{The ionization mode that has been used for the spectrum represented by the peaklist}

\item{findPeaksArgs}{A list of arguments that will be handed to the xcms-method findPeaks via do.call}

\item{plots}{A parameter that determines whether the spectra should be plotted or not}

\item{MSe}{A boolean value that determines whether the spectra were recorded using MSe or not}
}
\value{
The spectra generated from XCMS
}
\description{
Picks peaks from mz-files and returns the pseudospectra that CAMERA creates with the help of XCMS
}
\section{Functions}{
\itemize{
\item \code{findMsMsHRperxcms.direct()}: A submethod of findMsMsHrperxcms that retrieves basic spectrum data

}}
\examples{
\dontrun{
		fileList <- list.files(system.file("XCMSinput", package = "RMassBank"), "Glucolesquerellin", full.names=TRUE)[3]
	loadList(system.file("XCMSinput/compoundList.csv",package="RMassBank"))
     psp <- findMsMsHRperxcms(fileList,2184)
}
}
\seealso{
\code{\link{msmsWorkflow}} \code{\link{toRMB}}
}
\author{
Erik Mueller
}
