% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/SpectrumMethods.R,
%   R/AggregateMethods.R
\name{addProperty}
\alias{addProperty}
\alias{addProperty,RmbSpectrum2,character,character-method}
\alias{addProperty,data.frame,character,character-method}
\title{Add and initialize dataframe column}
\usage{
addProperty(o, name, type, value = NA)

\S4method{addProperty}{RmbSpectrum2,character,character}(o, name, type, value = NA)

\S4method{addProperty}{data.frame,character,character}(o, name, type, value = NA)
}
\arguments{
\item{o}{\code{data.frame} to add the column to}

\item{name}{Name of the new column}

\item{type}{Data type of the new column}

\item{value}{Initial value of the new column (\code{NA} if not given)}
}
\value{
Expanded data frame.
}
\description{
Adds a new column of a defined type to a \code{data.frame} and initializes it to a value.
The advantage of doing this over adding it with \code{$} or \code{[,""]} is that the case
\code{nrow(o) == 0} is adequately handled and doesn't raise an error.
}
\section{Methods (by class)}{
\itemize{
\item \code{addProperty(o = data.frame, name = character, type = character)}: Add a new column to a data.frame

}}
\author{
stravsmi
}
