% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rjmcmcMethodsIntern.R
\name{validatePrepMergeParameters}
\alias{validatePrepMergeParameters}
\title{Parameters validation for the \code{\link{postMerge}} function}
\usage{
validatePrepMergeParameters(reads, seqName, resultRJMCMC, extendingSize,
  chrLength)
}
\arguments{
\item{reads}{a \code{GRanges} containing all forward
and reverse reads.The start positions of both reads are going to be used
for the analysis. Beware that the start position of
a reverse read is always higher that the end positition. The \code{GRanges}
should at least contain one read.}

\item{seqName}{a \code{character} string containing the label of the
chromosome, present in the \code{GRanges} object, that will be used. The
\code{NULL} value is accepted when only one seqname is
present in the \code{GRanges}; the only seqname present will be used.}

\item{resultRJMCMC}{an object of \code{class}
"rjmcmcNucleosomes" or "rjmcmcNucleosomesMerge" that contain information
 about nucleosome positioning for an entire chromosome.}

\item{extendingSize}{a positive \code{numeric} or a positive \code{integer}
indicating the size of the consensus region used to group closeley
positioned nucleosomes.The minimum size of the consensus region is equal to
twice the value of the \code{extendingSize} parameter. The numeric will
be treated as an integer.}

\item{chrLength}{a positive \code{numeric} or a positive \code{integer}
indicating the lenght of the current chromosome. The length of the
chromosome is used to ensure that the consensus positions are all
located inside the chromosome.}
}
\value{
\code{0} indicating that all parameters validations have been
successful.
}
\description{
Validation of all parameters needed by the public
\code{\link{postMerge}} function.
}
\examples{

## Load dataset containing forward and reverse reads
data(reads_demo_01)

## Load dataset containing nucleosome information
file_002 <- dir(system.file("extdata", package = "RJMCMCNucleosomes"),
pattern = "RJMCMC_seg_02.RDS", full.names = TRUE)
nucleosome_info <- readRDS(file_002)

## The function returns 0 when all parameters are valid
RJMCMCNucleosomes:::validatePrepMergeParameters(reads = reads_demo_01,
seqName = "chr_SYNTHETIC", resultRJMCMC = nucleosome_info,
extendingSize = 74, chrLength = 10000000)

## The function raises an error when at least one paramater is not valid
\dontrun{RJMCMCNucleosomes:::validatePrepMergeParameters(
reads = c(72400, 72431, 72428, 72429, 72426),
resultRJMCMC = NA, extendingSize = 74, chrLength = 10000000)}

}
\author{
Astrid Deschenes
}
\keyword{internal}
