% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rjmcmcMethodsIntern.R
\name{rjmcmcNucleo}
\alias{rjmcmcNucleo}
\title{Interface for the RJMCMC nucleosome mapping method in C++}
\usage{
rjmcmcNucleo(startPosForwardReads, startPosReverseReads, nbrIterations, kMax,
  lambda, minInterval, maxInterval, minReads = 5L,
  adaptIterationsToReads = TRUE, vSeed = -1)
}
\arguments{
\item{startPosForwardReads}{a \code{vector} of \code{numeric}, the
start position of all the forward reads.}

\item{startPosReverseReads}{a \code{vector} of \code{numeric}, the
start position of all the reverse reads. Beware that the start position of
a reverse read is always higher that the end positition.}

\item{nbrIterations}{a positive \code{integer} or \code{numeric}, the
number of iterations. Non-integer values of
\code{nbrIterations} will be casted to \code{integer} and truncated towards
zero.}

\item{kMax}{a positive \code{integer} or \code{numeric}, the maximum number
of nucleosomes per region. Non-integer values
of \code{kMax} will be casted to \code{integer} and truncated towards zero.}

\item{lambda}{a positive \code{numeric}, the theorical mean
of the Poisson distribution. Default: 3.}

\item{minInterval}{a \code{numeric}, the minimum distance between two
nucleosomes.}

\item{maxInterval}{a \code{numeric}, the maximum distance between two
nucleosomes.}

\item{minReads}{a positive \code{integer} or \code{numeric}, the minimum
number of reads in a potential canditate region. Non-integer values
of \code{minReads} will be casted to \code{integer} and truncated towards
zero. Default: 5.}

\item{adaptIterationsToReads}{a \code{logical} indicating if the number
of iterations must be modified in function of the number of reads.
Default: \code{TRUE}.}

\item{vSeed}{a \code{integer}. A seed used when reproducible results are
needed. When a value inferior or equal to zero is given, a random integer
is used. Default: -1.}
}
\value{
a \code{list} containing:
\itemize{
    \item k a \code{integer}, the number of nucleosomes.
    \item k_max a \code{integer}, the maximum number of nucleosomes
obtained during the iteration process.
    \item it a \code{vector} of \code{integer} of length
\code{k}, the variance of the forward reads for each nucleosome.
    \item nbState a \code{integer}, the number of changes of state.
    \item mu a \code{matrix} of \code{numeric} with \code{k_max} columns
and \code{nbState} row containing, in each row, the \code{mu} values
associated the the state identified by the row number.
    \item muHat a \code{matrix} of \code{numeric} with \code{k_max} columns
and \code{k_max} rows containing, in each row, the mean \code{mu} values
associated the number of nucleosomes detected. The row number
corresponds to the number of nucleosomes detected.
    \item nbK a \code{vector} of length \code{k_max} containing
\code{integer}, the number of iterations
which detected a specific number of nucleosomes. The position in the vector
correspond to the number of nucleosomes.
}
}
\description{
Function that calls the core of the nucleosome positioning
mapping function that is implemented in C++.
}
\examples{

data(reads_demo_01)

forward <- start(reads_demo_01[strand(reads_demo_01) == "+"])
reverse <- end(reads_demo_01[strand(reads_demo_01) == "-"])

## Run nucleosome positioning
result <- RJMCMCNucleosomes:::rjmcmcNucleo(
            startPosForwardReads = forward,
            startPosReverseReads = reverse,
            nbrIterations = 1000, lambda = 2, kMax = 30,
            minInterval = 146, maxInterval = 292, minReads = 5,
            adaptIterationsToReads = TRUE, vSeed = -1)

## Print the final estimation of the number of nucleosomes
result$k

## Print the position of nucleosomes
result$mu

}
\author{
Pascal Belleau, Astrid Deschenes
}
\keyword{internal}
