% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rjmcmcMethod.R
\name{rjmcmc}
\alias{rjmcmc}
\title{Nucleosome positioning mapping on a segment}
\usage{
rjmcmc(reads, seqName = NULL, nbrIterations, kMax, lambda = 3, minInterval,
  maxInterval, minReads = 5, adaptIterationsToReads = TRUE, vSeed = -1,
  saveAsRDS = FALSE)
}
\arguments{
\item{reads}{a \code{GRanges} containing forward and
reverse reads. Beware that the start position of
a reverse read is always higher that the end positition.}

\item{seqName}{a \code{character} string containing the label of the
chromosome, present in the \code{GRanges} object, that will be used. The
\code{NULL} value is accepted when only one seqname is
present in the \code{GRanges}; the only seqname present will be used.
Default: \code{NULL}.}

\item{nbrIterations}{a positive \code{integer} or \code{numeric}, the
number of iterations. Non-integer values of
\code{nbrIterations} will be casted to \code{integer} and truncated towards
zero.}

\item{kMax}{a positive \code{integer} or \code{numeric}, the maximum number
of degrees of freedom per region. Non-integer values
of \code{kMax} will be casted to \code{integer} and truncated towards zero.}

\item{lambda}{a positive \code{numeric}, the theorical mean
of the Poisson distribution. Default: 3.}

\item{minInterval}{a \code{numeric}, the minimum distance between two
nucleosomes.}

\item{maxInterval}{a \code{numeric}, the maximum distance between two
nucleosomes.}

\item{minReads}{a positive \code{integer} or \code{numeric}, the minimum
number of reads in a potential canditate region. Non-integer values
of \code{minReads} will be casted to \code{integer} and truncated towards
zero. Default: 5.}

\item{adaptIterationsToReads}{a \code{logical} indicating if the number
of iterations must be modified in function of the number of reads.
Default: \code{TRUE}.}

\item{vSeed}{a \code{integer}. A seed used when reproducible results are
needed. When a value inferior or equal to zero is given, a random integer
is used. Default: -1.}

\item{saveAsRDS}{a \code{logical}. When \code{TRUE}, a RDS file containing
the complete output of the c++ rjmcmc() function is created.
Default : \code{FALSE}.}
}
\value{
a \code{list} of \code{class} "rjmcmcNucleosomes" containing:
\itemize{
\item \code{call} the matched call.
\item \code{k} a \code{integer}, the final estimation of the number
of nucleosomes. \code{0} when no nucleosome is detected.
\item \code{mu} a \code{GRanges} containing the positions of the
nucleosomes and '*' as strand. The \code{seqnames} of the \code{GRanges}
correspond to the \code{seqName} input value. \code{NA} when no nucleosome
is detected.
\item \code{k_max} a \code{integer}, the maximum number of nucleosomes
obtained during the iteration process. \code{NA} when no nucleosome is
detected.
}
}
\description{
Use of a fully Bayesian hierarchical model for chromosome-wide
profiling of nucleosome positions based on high-throughput short-read
data (MNase-Seq data). Beware that for a genome-wide profiling, each
chromosome must be treated separatly. This function is optimized to run
on segments that are smaller sections of the chromosome.
}
\examples{

## Loading dataset
data(reads_demo_01)

## Nucleosome positioning, running both merge and split functions
result <- rjmcmc(reads = reads_demo_01, seqName = "chr_SYNTHETIC",
            nbrIterations = 1000, lambda = 2, kMax = 30,
            minInterval = 146, maxInterval = 292, minReads = 5,
            vSeed = 10113, saveAsRDS = FALSE)

## Print the final estimation of the number of nucleosomes
result$k

## Print the position of nucleosomes
result$mu

## Print the maximum number of nucleosomes obtained during the iteration
## process
result$k_max

}
\author{
Rawane Samb, Pascal Belleau, Astrid Deschenes
}
