% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RJMCMCNucleosomes.R
\docType{data}
\name{reads_demo_02}
\alias{reads_demo_02}
\title{Forward reads and reverse reads in \code{GRanges} format
(for demo purpose).}
\format{A \code{GRanges} containing forward and reverse reads.}
\usage{
data(reads_demo_02)
}
\value{
A \code{GRanges} containing forward and reverse reads.
}
\description{
A group of forward and reverse reads that can be used to test the
\code{rjmcmc} function.
}
\examples{

## Loading dataset
data(reads_demo_02)

## Nucleosome positioning
## Since there is only one chromosome present in reads_demo_02, the name
## of the chromosome does not need to be specified
rjmcmc(reads = reads_demo_02, nbrIterations = 150, lambda = 3, kMax = 30,
            minInterval = 144, maxInterval = 290, minReads = 6)

}
\seealso{
\itemize{
    \item \code{\link{rjmcmc}} {for profiling of nucleosome positions}
    \item \code{\link{rjmcmcCHR}} { for profiling of nucleosome positions
    for a large region. The function will take care of spliting and
    merging.}
    \item \code{\link{segmentation}} { for spliting a \code{GRanges}
    containing reads in a list of smaller segments for
    the \code{rjmcmc} function.}
    \item \code{\link{postTreatment}} { for merging closely positioned
    nucleosomes}
    \item \code{\link{mergeRDSFiles}} { for merging nucleosome information
    from selected RDS files.}
    \item \code{\link{plotNucleosomes}} { for generating a graph containing
    the nucleosome positions and the read coverage.}
}
}
\keyword{datasets}
