% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.rjmcmcNucleosomesMerge.R
\name{print.rjmcmcNucleosomesMerge}
\alias{print.rjmcmcNucleosomesMerge}
\title{Formated output of predicted nucleosomes}
\usage{
\method{print}{rjmcmcNucleosomesMerge}(x, ...)
}
\arguments{
\item{x}{the output object from \code{mergeAllRDSFilesFromDirectory}
function to be printed}

\item{\ldots}{arguments passed to or from other methods}
}
\value{
an object of class \code{mergeAllRDSFilesFromDirectory}
}
\description{
Generated a formated output of a list marked as
an \code{rjmcmcNucleosomesMerge} class
}
\examples{

## Use a directory present in the RJMCMC package
directoryWithRDSFiles <- system.file("extdata",
package = "RJMCMCNucleosomes")

## Merge nucleosomes info from RDS files present in directory
## It is assumed that all files present in the directory are nucleosomes
## result for the same chromosome
result <- mergeAllRDSFilesFromDirectory(directoryWithRDSFiles)

## Show resulting nucleosomes
print(result)

## or simply
result

}
\author{
Astrid Deschenes
}
