% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Study.R
\name{mergeDomainAndSupplemental}
\alias{mergeDomainAndSupplemental}
\title{Merge the Domain dataframe and Supplemental dataframe (long form)}
\usage{
mergeDomainAndSupplemental(data_list)
}
\arguments{
\item{data_list}{A list of 1) Domain dataframe and 2) any Supplemental dataframe}
}
\value{
The merged dataframe
}
\description{
The Domain data list comprises of the the Domain datafrome that is in wide form, and any Supplemental
dataframe that is in long form. The function \code{mergeDomainAndSupplemental} transposes the Supplemental
dataframe into a wide form, and merges it with the Domain dataframe.
}
\examples{
library(DBI)
library(sqldf)
studies_dir <- system.file("extdata", "ImmPortStudies", package = "RImmPort")
db_dir <- file.path(studies_dir, "Db")
sqlite_conn <- dbConnect(SQLite(), dbname=file.path(db_dir, "ImmPort.sqlite"))
setImmPortDataSource(sqlite_conn)
l <- getDomainDataOfStudies("Cellular Quantification", "SDY208")
df <- mergeDomainAndSupplemental(l)
}

