% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Study.R
\name{getStudy}
\alias{getStudy}
\title{Get all data of a specific study from the ImmPort data source}
\usage{
getStudy(study_id)
}
\arguments{
\item{study_id}{Identifier of a specific study}
}
\value{
A study data object where in all data are structured as classes, domains, variables and values (in CDISC format)
}
\description{
The function \code{getStudy} queries the ImmPort data source for data of a specific study in 
all domains. The data is then structured into \code{Study} as classes, domains, variables and values.
}
\examples{
library(DBI)
library(sqldf)
studies_dir <- system.file("extdata", "ImmPortStudies", package = "RImmPort")
db_dir <- file.path(studies_dir, "Db")
sqlite_conn <- dbConnect(SQLite(), dbname=file.path(db_dir, "ImmPort.sqlite"))
setImmPortDataSource(sqlite_conn)
sdy139 <- getStudy("SDY139")
}

