% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Study.R
\name{getDomainDataOfStudies}
\alias{getDomainDataOfStudies}
\title{Get specific domain data of one or more studies from the ImmPort database}
\usage{
getDomainDataOfStudies(domain, study_ids)
}
\arguments{
\item{domain}{Name of a specific domain}

\item{study_ids}{List of study indentifiers}
}
\value{
a list of 1) domain data and 2) supplemental domain data of the studies
}
\description{
Get specific domain data of one or more studies from the ImmPort database
}
\examples{
library(DBI)
library(sqldf)
studies_dir <- system.file("extdata", "ImmPortStudies", package = "RImmPort")
db_dir <- file.path(studies_dir, "Db")
sqlite_conn <- dbConnect(SQLite(), dbname=file.path(db_dir, "ImmPort.sqlite"))
setImmPortDataSource(sqlite_conn)
dm_df <- getDomainDataOfStudies("Demographics", "SDY139")
}

