% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib_enrichment.R
\name{writeGMT}
\alias{writeGMT}
\title{writeGMT}
\usage{
writeGMT(s, file = NA, link = rep("", length(s)))
}
\arguments{
\item{s}{list of gene sets in current R session. Each entry will become a row in the GMT file.}

\item{file}{file name to write to}

\item{link}{default is "". This is the second column of a GMT file and is usually a hyperlink or note about the origin of the term}
}
\value{
Nothing is returned. A file is written.
}
\description{
Created for future use and simplification of writing .gmt files from the package.
}
\examples{
# Make an example list() to show the GMT format
set <- list( term1=c('gene_name1','gene_name2'),
             term2=c('gene_name3','gene_name4','gene_name5') )
\dontrun{
# Write a GMT file for "set"
writeGMT( set, 'my_file.gmt')
}
}
