% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib_enrichment.R
\name{readGMT}
\alias{readGMT}
\title{readGMT}
\usage{
readGMT(f = NA)
}
\arguments{
\item{f}{GMT file name. Please provide a full path if the file is not in the current working directory.}
}
\value{
A list() where the name of each entry is the term (first column of GMT file) and the value is a chr array of genes associated with the term.
}
\description{
Created for simplification of reading .gmt files into RITAN.
}
\examples{
# Make an example list() to show the GMT format
set <- list( term1=c('gene_name1','gene_name2'),
             term2=c('gene_name3','gene_name4','gene_name5') )
\dontrun{
# Write a GMT file for "set"
writeGMT( set, 'my_file.gmt' )

# Reading GMT files
geneset <- readGMT( 'my_file.gmt' )

# Additional GMT files are available from multiple sources.
#   We recommend:
#   http://software.broadinstitute.org/gsea/msigdb/
}

}
