% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib_enrichment.R
\name{plot.term_enrichment}
\alias{plot.term_enrichment}
\title{plot.term_enrichment}
\usage{
\method{plot}{term_enrichment}(x = NA, min_q = 0.05, max_terms = 25, extend_mar = c(0, 10, 0, 0), ...)
}
\arguments{
\item{x}{data frame returned by term_enrichment}

\item{min_q}{Only q-values more significant than this threshold will be plotted. Default = 0.05.}

\item{max_terms}{Up to max_terms will be plotted. Default = 25.}

\item{extend_mar}{Term names can be long. We attempt to keep them readable by extending the left-hand-side margins automatically. Default = c(0,10,0,0) added to par()$mar.}

\item{...}{Additional arguments are passed on to plot()}
}
\value{
silent return from plot
}
\description{
plot.term_enrichment
}
\examples{
require(RITANdata)
e <- term_enrichment(vac1.day0vs31.de.genes, resources = 'GO_slim_generic')
plot(e, min_q = .1)

}
