% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib_enrichment.R
\name{load_geneset_symbols}
\alias{load_geneset_symbols}
\title{load_geneset_symbols}
\usage{
load_geneset_symbols(gmt = NA, gmt_dir = "", verbose = TRUE)
}
\arguments{
\item{gmt}{Either 1) name of pre-loaded resource (i.e. names(geneset_list)) or 2) gmt file containing annotation resources for enrichment annotation}

\item{gmt_dir}{location of gmt file named in gmt parameter}

\item{verbose}{print results to screen}
}
\value{
R list object named active_genesets
}
\description{
For most applications, this function is used internally by term_enrichment(). Users may call this function directly in some cases to force FDR adjustment to be across multiple resources. See Vignette for more details.
}
\details{
load_geneset_symbols allows the user to specify an annotation resource (e.g. Gene Ontology terms)
to use in enrichment analysis. The expectation is that the annotation resource contains of at least
one set of genes in the form of a list. The RITAN package comes with 15 pre-loaded annotation
resources. The default active annotation resources are GO, ReactomePathways,
KEGG_filtered_canonical_pathways, and MSigDB_Hallmarks.

The result of calling this function is to set the variable "active_genesets" which will be used by further functions.
}
\examples{
## Load generic GO-slim terms
require(RITANdata)
load_geneset_symbols("GO_slim_generic")
print(length(active_genesets))
print(head(active_genesets[[1]]))

\dontrun{
## load the default set of resources into "active_genesets"
load_geneset_symbols()

## Use only the Reactome Pathways annotation resource.
load_geneset_symbols(gmt="ReactomePathways")

## Suppresses output message describing the annotation resource and size.
load_geneset_symbols(gmt="ReactomePathways", verbose=FALSE)

## To list the available resources within RITAN:
print(names(geneset_list))

## You can also load your own data
load_geneset_symbols(gmt="myFile.gmt")
}
}
