% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib_network.R
\name{check_net_input}
\alias{check_net_input}
\title{check_net_input}
\usage{
check_net_input(
  set,
  ref,
  check4similar = FALSE,
  entity1name = "p1",
  entity2name = "p1"
)
}
\arguments{
\item{set}{An input list of genes to check against a reference.}

\item{ref}{A reference of network data. See readSIF().}

\item{check4similar}{Logical flag. If TRUE, a case-insensitive grep will be used for name matching. For genes in families with many related members (e.g. ABC*, FAM*, etc.), this will not be ideal. We intend this option as a QC screening method to identify if case, punctuaiton, etc is causing fewer than expected matches.}

\item{entity1name}{The column name in "ref" of the first entity. Default = "p1."}

\item{entity2name}{The column name in "ref" of the second entity. Default = "p2."}
}
\value{
Character vector of "yes/no" indicating "within-ref/not"
}
\description{
A Quality Control function. This function will compare an input list of genes to a network reference and report if each member of the input is present in the resource.
}
\examples{
## Return a "yes/no" vector indicating if each gene in myGeneSet is annotated with any term in GO
## If no match, this function can attempt to suggest closest matches (check4similar = TRUE)
library(RITANdata)
myGeneSet <- c('BRCA1','RAD51C','VAV1','HRAS','ABCC1','CYP1B1','CYP3A5')
yorn <- check_net_input( myGeneSet, network_list[["CCSB"]] )
print(yorn)

yorn <- check_net_input( myGeneSet, network_list[["PID"]] )
print(yorn)

## See check_any_net_input() for efficiently checking across all resources.
}
