% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib_network.R
\name{check_any_net_input}
\alias{check_any_net_input}
\title{check_any_net_input}
\usage{
check_any_net_input(set, resources = names(network_list))
}
\arguments{
\item{set}{An input list of genes to check against references.}

\item{resources}{The collection of network resources to check within.}
}
\value{
Logical vector indicating if the genes in "set" are within ANY of the resources.
}
\description{
A Quality Control function. This function applies check_net_input() to all available resources (default).
}
\examples{
#' ## Check if genes in myGeneSet are annotated by any resource in "network_list" (default).
library(RITANdata)
myGeneSet <- c('BRCA1','RAD51C','VAV1','HRAS','ABCC1','CYP1B1','CYP3A5')
yorn <- check_any_net_input( myGeneSet )
print(yorn)
}
