% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecoseed.R
\docType{data}
\name{ecoseed.df}
\alias{ecoseed.df}
\title{Ecoseed project data}
\format{
A list of data.frame containing
     \itemize{
       \item design: a data.frame with experiment design,
       \item RNAtest: a data.frame with RNAseq data,
       \item protetest: a data.frame with proteomics data,
       \item metatest: a data.frame with metabolomics data
     }
}
\usage{
data("ecoseed.df")
}
\description{
This dataset is provided by the EcoSeed project (FP7-KBBE; Impacts of 
Environmental Conditions on Seed Quality). that investigates the 
effect of seed production temperature on the germination potential of 
Arabidopsis thaliana.

This dataset is a multi-omics dataset composed of three data matrices:
transcriptomics (raw RNAseq read count data matrix), metabolomics and proteomics
(relative abundance matrix as XIC).

These data are provided in 2 object: ecoseed.df and ecoseed.mae
}
\examples{
data("ecoseed.df")

# list of data.frames
names(ecoseed.df)
head(ecoseed.df$design)
}
\references{
FP7-KBBE; Impacts of Environmental Conditions on Seed Quality
}
\keyword{datasets}
