% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signatures.clustering.R
\name{signaturesClustering}
\alias{signaturesClustering}
\title{signaturesClustering}
\usage{
signaturesClustering(
  alpha,
  num_clusters = 1:10,
  num_processes = Inf,
  verbose = TRUE
)
}
\arguments{
\item{alpha}{Signatures assignments matrix.}

\item{num_clusters}{Range of number of clusters to be considered.}

\item{num_processes}{Number of processes to be used during parallel execution. To execute in single process mode,
this parameter needs to be set to either NA or NULL.}

\item{verbose}{Boolean. Shall I print information messages?}
}
\value{
A list a clusters assignments for each number within the num_clusters range.
}
\description{
Perform signatures based clustering given the signatures assignments matrix alpha.
}
\examples{
data(sbs_assignments)
set.seed(12345)
norm_alpha = (sbs_assignments$alpha / rowSums(sbs_assignments$alpha))
sbs_clustering = signaturesClustering(alpha = norm_alpha, num_clusters = 1:3, 
                                      num_processes = 1, verbose = FALSE)

}
