% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.import.R
\name{getMNVCounts}
\alias{getMNVCounts}
\title{getMNVCounts}
\usage{
getMNVCounts(data, predefined_dbs_mbs = FALSE)
}
\arguments{
\item{data}{A data.frame with variants having 6 columns: sample name, chromosome, start position, end position, ref, alt.}

\item{predefined_dbs_mbs}{Boolean. As defined by the function get_mut_type from the package MutationalPatterns, it specifies whether 
dbs and mbs mutations have been predefined in the input data. This function by default assumes that dbs and mbs mutations are present 
in the vcf as snvs, which are positioned next to each other. If your dbs/mbs mutations are called separately, you should set this 
argument to TRUE.}
}
\value{
A matrix with Multi-Nucleotide Variants (MNVs) counts per patient.
}
\description{
Create Multi-Nucleotide Variants (MNVs) counts matrix from input data.
}
\examples{
data(ssm560_reduced)
res <- getMNVCounts(data = ssm560_reduced)

}
