% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/associations.estimation.R
\name{associationSignatures}
\alias{associationSignatures}
\title{associationSignatures}
\usage{
associationSignatures(alterations, signatures)
}
\arguments{
\item{alterations}{Matrix with the observed mutations (columns) for each patient (rows) as binary variables.}

\item{signatures}{Matrix with the estimated exposures to signatures (columns) for each patient (rows).}
}
\value{
A list with the association estimates. It includes 6 elements:
             alterations: matrix with the observed mutations (columns) for each patient (rows) as binary variables.
             signatures: matrix with the estimated exposures to signatures (columns) for each patient (rows).
             associations: estimated associations.
             intercept: intercept resulting from the regularized regression estimate.
             probabilities: probability of observing a mutation in a certain gene given the presence of specific signatures.
             fold_changes: fold changes estimating the strength of the associations.
}
\description{
Perform the estimation of the mutational signatures associated to mutations in specific genes.
}
\examples{
data(association_mutations)
set.seed(12345)
alterations = association_mutations$alterations
normalized_alpha = association_mutations$normalized_alpha
association_signatures = associationSignatures(alterations = alterations, signatures = normalized_alpha)

}
