% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REMPtools.R
\name{fetchRMSK}
\alias{fetchRMSK}
\title{Get RE database from RepeatMasker}
\usage{
fetchRMSK(
  REtype = c("Alu", "L1", "ERV"),
  annotation.source = c("AH", "UCSC"),
  genome = c("hg19", "hg38"),
  verbose = FALSE
)
}
\arguments{
\item{REtype}{Type of RE. Currently \code{"Alu"}, \code{"L1"}, and \code{"ERV"} are supported.}

\item{annotation.source}{Character parameter. Specify the source of annotation databases, including
the RefSeq Gene annotation database and RepeatMasker annotation database. If \code{"AH"}, the database 
will be obtained from the AnnotationHub package. If \code{"UCSC"}, the database will be downloaded 
from the UCSC website http://hgdownload.cse.ucsc.edu/goldenpath. The corresponding build (\code{"hg19"} or 
\code{"hg38"}) will be specified in the parameter \code{genome}.}

\item{genome}{Character parameter. Specify the build of human genome. Can be either \code{"hg19"} or
\code{"hg38"}.}

\item{verbose}{Logical parameter. Should the function be verbose?}
}
\value{
A \code{\link{GRanges}} object containing RE database. 'repName' column
indicates the RE name; 'swScore' column indicates the SW score; 'Index' is an
internal index for RE to facilitate data referral, which is meaningless for external use.
}
\description{
\code{fetchRMSK} is used to obtain specified RE database from RepeatMasker Database
provided by AnnotationHub.
}
\examples{
L1 <- fetchRMSK(REtype = "L1", 
                annotation.source = "AH",
                genome = "hg19", 
                verbose = TRUE)
L1
}
