% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REMProduct-class.R, R/generics.R,
%   R/REMProduct-methods.R
\name{REMProduct-class}
\alias{REMProduct-class}
\alias{REMProduct}
\alias{rempM}
\alias{rempB}
\alias{rempQC}
\alias{rempAnnot}
\alias{rempImp}
\alias{rempStats}
\alias{remplot}
\alias{details}
\alias{decodeAnnot}
\alias{rempTrim}
\alias{rempAggregate}
\alias{rempCombine}
\alias{rempM,REMProduct-method}
\alias{rempB,REMProduct-method}
\alias{rempQC,REMProduct-method}
\alias{rempImp,REMProduct-method}
\alias{rempAnnot,REMProduct-method}
\alias{rempStats,REMProduct-method}
\alias{remplot,REMProduct-method}
\alias{details,REMProduct-method}
\alias{decodeAnnot,REMProduct-method}
\alias{rempTrim,REMProduct-method}
\alias{rempAggregate,REMProduct-method}
\alias{rempCombine,REMProduct,REMProduct-method}
\title{REMProduct instances}
\usage{
REMProduct(
  REtype = "Unknown",
  genome = "Unknown",
  platform = "Unknown",
  win = "Unknown",
  predictModel = "Unknown",
  QCModel = "Unknown",
  rempM = NULL,
  rempB = NULL,
  rempQC = NULL,
  cpgRanges = GRanges(),
  sampleInfo = DataFrame(),
  REannotation = GRanges(),
  RECpG = GRanges(),
  regionCode = DataFrame(),
  refGene = GRanges(),
  varImp = DataFrame(),
  REStats = DataFrame(),
  GeneStats = DataFrame(),
  Seed = NULL
)

rempM(object)

rempB(object)

rempQC(object)

rempAnnot(object)

rempImp(object)

rempStats(object)

remplot(object, ...)

details(object)

decodeAnnot(object, ...)

rempTrim(object, ...)

rempAggregate(object, ...)

rempCombine(object1, object2)

\S4method{rempM}{REMProduct}(object)

\S4method{rempB}{REMProduct}(object)

\S4method{rempQC}{REMProduct}(object)

\S4method{rempImp}{REMProduct}(object)

\S4method{rempAnnot}{REMProduct}(object)

\S4method{rempStats}{REMProduct}(object)

\S4method{remplot}{REMProduct}(object, type = c("individual", "overall"), ...)

\S4method{details}{REMProduct}(object)

\S4method{decodeAnnot}{REMProduct}(object, type = c("symbol", "entrez"), ncore = 1, BPPARAM = NULL)

\S4method{rempTrim}{REMProduct}(object, threshold = 1.7, missingRate = 0.2)

\S4method{rempAggregate}{REMProduct}(object, NCpG = 2, ncore = 1, BPPARAM = NULL)

\S4method{rempCombine}{REMProduct,REMProduct}(object1, object2)
}
\arguments{
\item{REtype}{Type of RE (\code{"Alu"}, \code{"L1"}, or \code{"ERV"}).}

\item{genome}{Specify the build of human genome. Can be either \code{"hg19"} or \code{"hg38"}.}

\item{platform}{Illumina methylation profiling platform (\code{"450k"} or \code{"EPIC"}).}

\item{win}{Flanking window size of the predicting RE-CpG.}

\item{predictModel}{Name of the model used for prediction.}

\item{QCModel}{Name of the model used for prediction quality evaluation.}

\item{rempM}{Predicted methylation level in M value.}

\item{rempB}{Predicted methylation level in beta value (optional).}

\item{rempQC}{Prediction quality scores, which is available only when Random Forest
model is used in \code{\link{remp}}.}

\item{cpgRanges}{Genomic ranges of the predicting RE-CpG.}

\item{sampleInfo}{Sample information.}

\item{REannotation}{Annotation data for the predicting RE.}

\item{RECpG}{Annotation data for the RE-CpG profiled by Illumina platform.}

\item{regionCode}{Internal index code defined in \code{refGene} for gene region indicators.}

\item{refGene}{refSeq gene annotation data, which can be obtained by \code{\link{fetchRefSeqGene}}.}

\item{varImp}{Importance of the predictors.}

\item{REStats}{RE coverage statistics, which is internally generated in \code{\link{remp}}.}

\item{GeneStats}{Gene coverage statistics, which is internally generated in \code{\link{remp}}.}

\item{Seed}{Random seed for Random Forest model for reproducible prediction results.}

\item{object}{A \code{REMProduct} object.}

\item{...}{For \code{plot}: \code{\link{graphical parameters}} to be passed to the \code{plot} method.}

\item{object1}{A \code{REMProduct} object.}

\item{object2}{A \code{REMProduct} object.}

\item{type}{For \code{plot} and \code{decodeAnnot}: see Utilities.}

\item{ncore}{For \code{decodeAnnot} and \code{rempAggregate}: number of cores used for parallel computing.
By default no parallel computing is allowed (\code{ncore = 1}).}

\item{BPPARAM}{For \code{decodeAnnot} and \code{rempAggregate}: an optional \code{\link{BiocParallelParam}}
instance determining the parallel back-end to be used during evaluation. If not specified, default
back-end in the machine will be used.}

\item{threshold}{For \code{rempTrim}: see Utilities.}

\item{missingRate}{For \code{rempTrim}: see Utilities.}

\item{NCpG}{For \code{rempAggregate}: see Utilities.}
}
\value{
An object of class \code{REMProduct} for the constructor.
}
\description{
Class \code{REMProduct} is to maintain RE methylation prediction results.
\code{REMProduct} inherits Bioconductor's \code{RangedSummarizedExperiment} class.
}
\section{Accessors}{

\describe{
    \item{\code{rempM(object)}}{Return M value of the prediction.}
    \item{\code{rempB(object)}}{Return beta value of the prediction.}
    \item{\code{rempQC(object)}}{Return prediction quality scores.}
    \item{\code{rempImp(object)}}{Return relative importance of predictors.}
    \item{\code{rempStats(object)}}{Return RE and gene coverage statistics.}
    \item{\code{rempAnnot(object)}}{Return annotation data for the predicted RE.}
    }
}

\section{Utilities}{

\describe{
    \item{\code{remplot(object, type = c("individual", "overall"), ...)}}{Make a density plot of predicted methylation
    (beta values) in the \code{REMProduct} object. If \code{type = "individual"}, density curves will be
    plotted for each of the samples; If \code{type = "overall"}, one density curve of the mean methylation level
    across the samples will be plotted. Default \code{type = "individual"}.}
    \item{\code{details(object)}}{Display detailed descriptive statistics of the predicion results.}
    \item{\code{decodeAnnot(object, type = c("symbol", "entrez")), ncore = NULL, BPPARAM = NULL}}{Decode the
    RE annotation data by Gene Symbol (when \code{type = "Symbol"}) or Entrez Gene
    (when \code{type = "Entrez"}).Default \code{type = "Symbol"}. Annotation data are provided by
    \code{\link{org.Hs.eg.db}}.}
    \item{\code{rempTrim(object, threshold = 1.7, missingRate = 0.2)}}{Any predicted CpG values with
    quality score < threshold (default = 1.7, specified by \code{threshold = 1.7}) will be replaced with NA.
    CpGs contain more than missingRate * 100% (default = 20%, specified by \code{missingRage = 0.2}) missing
    rate across samples will be discarded. Relavant summary statistics will be re-evaluated.}
    \item{\code{rempAggregate(object, NCpG = 2, ncore = NULL, BPPARAM = NULL)}}{Aggregate the predicted RE-CpG
    methylation by RE using mean. To ensure the reliability of the aggregation, by default only RE with at
    least 2 predicted CpG sites (specified by \code{NCpG = 2}) will be aggregated.}
    \item{\code{rempCombine(object1, object2)}}{Combine two \code{REMProduct} objects by column.}
    }
}

\examples{
showClass("REMProduct")
}
