% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCyjs-class.R
\name{showEdges,RCyjs-method}
\alias{showEdges,RCyjs-method}
\alias{showEdges}
\title{showEdges}
\usage{
\S4method{showEdges}{RCyjs}(obj, edgeType)
}
\arguments{
\item{obj}{an RCyjs instance}

\item{edgeType}{a character string}
}
\value{
no return value
}
\description{
\code{showEdges} if hidden, edges of the specified type will be made visible
}
\details{
edgeType is a crucial feature for RCyjs.  We assume it is an attribute found
on every edge in every graph.
}
\examples{
if(interactive()){
   rcy <- RCyjs(title="rcyjs demo", graph=simpleDemoGraph())
   getNodes(rcy)
   edaNames(rcy)        # includes "edgeType"
   eda(rcy, "edgeType")  # includes "phosphorylates"
   hideEdges(rcy, edgeType="phosphorylates")
   showEdges(rcy, edgeType="phosphorylates")
   }

}
