% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCyjs-class.R
\name{setEdgeStyle,RCyjs-method}
\alias{setEdgeStyle,RCyjs-method}
\alias{setEdgeStyle}
\title{setEdgeStyle}
\usage{
\S4method{setEdgeStyle}{RCyjs}(obj, mode = c("bezier", "haystack"))
}
\arguments{
\item{obj}{an RCyjs instance}

\item{mode}{a character string, either "bezier" or "haystack"}
}
\value{
no return value
}
\description{
\code{setEdgeStyle} plain & fast (haystack) vs fancy & slower (bezier)
}
\details{
cytoscape.js offers two kinds of edge rendering - a tradeoff in richess and speed
edge target decorations (arrows, tee, etc) are only rendered with the "bezier" style
}
\examples{
if(interactive()){
   g <- simpleDemoGraph()
   rcy <- RCyjs(title="rcyjs demo", graph=g)
   layout(rcy, "cose")
   fit(rcy, 100)
   loadStyleFile(rcy, system.file(package="RCyjs", "extdata", "sampleStyle2.js"))
   setEdgeStyle(rcy, "bezier")
   redraw(rcy)
   }

}
