% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCyjs-class.R
\name{saveJPG,RCyjs-method}
\alias{saveJPG,RCyjs-method}
\alias{saveJPG}
\title{saveJPG}
\usage{
\S4method{saveJPG}{RCyjs}(obj, filename, resolutionFactor = 1)
}
\arguments{
\item{obj}{an RCyjs instance}

\item{filename}{a character string}

\item{resolutionFactor}{numeric, default 1, higher values multiply resolution beyond screen dpi}
}
\value{
no return value
}
\description{
\code{saveJPG} write current cytoscape view, at current resolution, to a JPG file.
}
\examples{
if(interactive()){
   rcy <- RCyjs(title="layouts", graph=createTestGraph(nodeCount=20, edgeCount=20))
   style.filename <- system.file(package="RCyjs", "extdata", "sampleStyle1.js");
   loadStyleFile(rcy, style.filename)
   layout(rcy, "cose")
   fit(rcy)
   filename <- tempfile(fileext=".jpg")
   saveJPG(rcy, filename, resolutionFactor)
   }
}
