% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkSelection.R
\name{selectEdges}
\alias{selectEdges}
\title{Select Edges}
\usage{
selectEdges(
  edges,
  by.col = "SUID",
  preserve.current.selection = TRUE,
  network = NULL,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{edges}{List of edge SUIDs, names or other column values}

\item{by.col}{Edge table column to lookup up provide edge values. Default is 
'SUID'.}

\item{preserve.current.selection}{\code{boolean} Whether to maintain 
previously selected edges.}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
\code{list} of newly selected edge SUIDs
}
\description{
Select edges in the network by SUID, name or other column values.
}
\examples{
\donttest{
selectEdges()
}
}
\author{
AlexanderPico, Tanja Muetze, Georgi Kolishovski, Paul Shannon
}
