% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Session.R
\name{saveSession}
\alias{saveSession}
\title{Save Session to File}
\usage{
saveSession(filename = NULL, base.url = .defaultBaseUrl, overwriteFile = TRUE)
}
\arguments{
\item{filename}{Full path or path relative to current working directory, 
in addition to the name of the file. The \code{.cys} extension is 
automatically added. Leave blank to update previously saved session file.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}

\item{overwriteFile}{(optional) FALSE allows an error to be generated if the file already exists;
TRUE allows Cytoscape to overwrite it without asking. Default value is TRUE.}
}
\value{
server response
}
\description{
Saves the current Cytoscape session as a CYS file.
}
\details{
If no \code{filename} is provided, then it attempts to
save to an existing CYS file associated with the session. If 
\code{filename} already exists, then it is overwritten.

Unlike most export functions in RCy3, Cytoscape will automatically
overwrite CYS session files with the same name. You will not be prompted to
confirm or reject overwrite. Use carefully!
}
\examples{
\donttest{
saveSession('/fullpath/mySession')
saveSession() 
}
}
