% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sandbox.R
\name{sandboxUrlTo}
\alias{sandboxUrlTo}
\title{sandboxUrlTo}
\usage{
sandboxUrlTo(
  sourceURL,
  destFile,
  overwrite = TRUE,
  sandboxName = NULL,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{sourceURL}{URL addressing cloud file to download}

\item{destFile}{Name of file in the R workflow's file system ... if None, use file name in source_file}

\item{overwrite}{Name of sandbox containing file. None means "the current sandbox".}

\item{sandboxName}{Name of sandbox containing file. None means "the current sandbox".}

\item{base.url}{Ignore unless you need to specify a custom domain, port or version to connect to the CyREST API. Default is http://127.0.0.1:1234 and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
dict: {'filePath': <new file's absolute path in Cytoscape workstation>, 'fileByteCount': number of bytes read}
}
\description{
Transfer a cloud-based file to a sandbox.
The source URL identifies a file to be transferred to the named (or current) sandbox, overwriting an existing
file if one already exists. The destFile can be an absolute path if the sandbox is the entire file
system (i.e., for standalone R execution), or it can be a path relative to the sandbox (i.e., for Notebook or
remote execution or if a sandbox was explicitly created).
}
\examples{
\donttest{
sandboxUrlTo()
}
}
