% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sandbox.R
\name{sandboxRemoveFile}
\alias{sandboxRemoveFile}
\title{sandboxRemoveFile}
\usage{
sandboxRemoveFile(fileName, sandboxName = NULL, base.url = .defaultBaseUrl)
}
\arguments{
\item{fileName}{Name of file to delete (as absolute path or sandbox-relative path)}

\item{sandboxName}{Name of sandbox containing file. None means "the current sandbox".}

\item{base.url}{Ignore unless you need to specify a custom domain, port or version to connect to the CyREST API. Default is http://127.0.0.1:1234 and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
dict: {'filePath': <file's absolute path in Cytoscape workstation>, 'existed': True if file existed before being deleted}
}
\description{
Remove a file from a sandbox.
The named file is removed from the named sandbox. If the sandbox is the entire file system (i.e., for standalone
R execution), the file name can be an absolute path. Otherwise, it is a path relative to the named sandbox.
Note that there is no function that deletes a directory, except for sandboxRemove(), which deletes a sandbox
and all of its contents.
}
\examples{
\donttest{
sandboxRemoveFile()
}
}
