% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Networks.R
\name{createIgraphFromNetwork}
\alias{createIgraphFromNetwork}
\title{Create an igraph network from a Cytoscape network}
\usage{
createIgraphFromNetwork(network = NULL, base.url = .defaultBaseUrl)
}
\arguments{
\item{network}{(optional) Name or SUID of the network. Default is the "current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
(igraph) an igraph network
}
\description{
Takes a Cytoscape network and generates data frames for vertices and edges to
send to the graph_from_data_frame function.
Returns the network.suid and applies the perferred layout set in Cytoscape preferences.
}
\details{
Nodes and edges from the Cytoscape network will be translated into vertices and edges
in igraph. Associated table columns will also be passed to igraph as vertiex and
 edge attributes. Note: all networks are implicitly modeled as directed
in Cytoscape. Round-trip conversion of an undirected network in igraph via
\code{createNetworkFromIgraph} to Cytoscape and back to igraph will result in
a directed network.
}
\examples{
\donttest{
ig <- createIgraphFromNetwork()
ig <- createIgraphFromNetwork('myNetwork')
}
}
\seealso{
createNetworkFromDataFrames, createNetworkFromIgraph
}
