% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Visualize.R
\name{writeHTML}
\alias{writeHTML}
\alias{writeHTML.RCX}
\alias{writeHTML.CX}
\title{Save network visualization as HTML file}
\usage{
writeHTML(x, file, layout = NULL, verbose = FALSE)

\method{writeHTML}{RCX}(x, file, layout = NULL, verbose = FALSE)

\method{writeHTML}{CX}(x, file, layout = NULL, verbose = FALSE)
}
\arguments{
\item{x}{network; \link[=RCX-object]{RCX} or CX object}

\item{file}{character; path, where the html file should be saved}

\item{layout}{named character or list; e.g. \code{c(name="random")}}

\item{verbose}{logical; whether to print what is happening}
}
\value{
file character; path, where the html file has been saved
}
\description{
Save an interactive single page visualization of \link[=RCX-object]{RCX} and CX networks as an HTML file
containing all necessary Java Script.
}
\details{
This function uses the Java Script library used by the NDEx platform (\url{https://ndexbio.org/}) to visualize
the \link[=RCX-object]{RCX} or \link[=readCX]{CX} network.
The \link[=RCX-object]{RCX} is therefore converted to CX (JSON) using \link{toCX}.

If the network contains the necessary Cytoscape styles (see \url{http://manual.cytoscape.org/en/stable/Styles.html})
the network is visualized as seen on the NDEx platform.

To define the layout of the network the coordinate from \link{CartesianLayout} are used to determine the location of
the nodes. If this aspect is missing, or the the coordinates should be ignored, the \emph{layout} parameter can be used
to set a different layout.

\emph{layout} follows therefore the definition of Cytoscape.js (see \url{https://js.cytoscape.org/#layouts}).
A simple definition can be setting only the \emph{name} of the desired layout, e.g. \code{random}.
Additional options can be passed as named list, where the values are passed without quoting.
This allows for even passing Java Script functions to Cytoscape.js.

To visualize the network in RStudio the \link{visualize} function can be used instead.
}
\examples{
## prepare RCX
rcx = createRCX(
  createNodes(name = c("a","b","c")), 
  createEdges(
    source=c(0,0,1), 
    target=c(1,2,2)
  )
)

cx = toCX(rcx)

htmlFile = tempfile(fileext = ".html")

## save the html
writeHTML(rcx, htmlFile)

## or
writeHTML(cx, htmlFile)

## force a different layout
writeHTML(rcx, htmlFile, c(name="cose"))

## force a different layout with Java Script parameters
writeHTML(rcx, htmlFile, layout = c(name="random",animate="true"))

## even pass a Java Script function
writeHTML(
   rcx, 
   htmlFile, 
   layout = c(
     name="random",
     animate="true",
     animateFilter="function ( node, i ){ return true; }"
   )
)
}
\seealso{
\link{rcxToJson}, \link{readCX}, \link{writeCX}
}
