% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-NodeEdgeNetworkAttributes.R
\name{updateNetworkAttributes}
\alias{updateNetworkAttributes}
\alias{updateNetworkAttributes.NetworkAttributesAspect}
\alias{updateNetworkAttributes.RCX}
\title{Update network attributes}
\usage{
updateNetworkAttributes(
  x,
  networkAttributes,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  ...
)

\method{updateNetworkAttributes}{NetworkAttributesAspect}(
  x,
  networkAttributes,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  ...
)

\method{updateNetworkAttributes}{RCX}(
  x,
  networkAttributes,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  checkReferences = TRUE,
  ...
)
}
\arguments{
\item{x}{\link[=RCX-object]{RCX} object; (to which the new network attributes will be added)}

\item{networkAttributes}{\code{\link{NetworkAttributes}} object; (the new aspect, that will be added)}

\item{replace}{logical; if existing values are updated (or ignored)}

\item{stopOnDuplicates}{logical; whether to stop, if duplicates in \emph{name} (and \emph{subnetworkId} if present) column are found}

\item{...}{additional parameters}

\item{checkReferences}{logical; whether to check if references to other aspects are present in the \link[=RCX-object]{RCX} object}
}
\value{
\code{\link{NetworkAttributes}} or \link[=RCX-object]{RCX} object with added network attributes
}
\description{
This functions add network attributes in the form of a \code{\link{NetworkAttributes}} object to an \link[=RCX-object]{RCX} or an other
\code{\link{NetworkAttributes}} object.
}
\details{
Networks may have attributes, that are represented as \code{\link{NetworkAttributes}} objects.
\code{\link{NetworkAttributes}} objects can be added to an \link[=RCX-object]{RCX} or an other \code{\link{NetworkAttributes}} object.

In the case, that a \code{\link{NetworkAttributes}} object is added to an other, or the \link[=RCX-object]{RCX} object already contains a
\code{\link{NetworkAttributes}} object, some attributes might be present in both. By default, the attributes are updated with the values
of the latest one. This can prevented by setting the \emph{replace} parameter to \code{FALSE}, in that case only new attributes are added and
the existing attributes remain untouched.

Furthermore, if duplicated attributes are considered as a preventable mistake, an error can be raised by setting \emph{stopOnDuplicates}
to \code{TRUE}. This forces the function to stop and raise an error, if duplicated attributes are present.
}
\examples{
## For NetworkAttributesAspects: 
## prepare some aspects:
networkAttributes1 = createNetworkAttributes(
  name=c("A","A","B","B"),
  value=list(c("a1","a2"),
             "a with subnetwork",
             "b",
             "b with subnetwork"),
  isList=c(TRUE,FALSE,TRUE,FALSE),
  subnetworkId=c(NA,1,NA,1)
)

## A is updated, C is new 
networkAttributes2 = createNetworkAttributes(
  name=c("A","A","C"),
  value=list("new a",
             "new a with subnetwork",
             c(1,2)),
  subnetworkId=c(NA,1,NA)
)

## Simply update with new values
networkAttributes3 = updateNetworkAttributes(networkAttributes1, networkAttributes2)

## Ignore already present keys
networkAttributes3 = updateNetworkAttributes(networkAttributes1, networkAttributes2, 
                                             replace=FALSE)

## Raise an error if duplicate keys are present
try(updateNetworkAttributes(networkAttributes1, networkAttributes2, 
                            stopOnDuplicates=TRUE))
## =>ERROR: 
## Provided IDs (name, subnetworkId) countain duplicates!

## For RCX
## prepare RCX object:
nodes = createNodes(name = c("a","b","c","d","e","f"))
edges = createEdges(source=c(1,2,0,0,0,2), 
                    target=c(2,3,1,2,5,4))
rcx = createRCX(nodes, edges)
cySubNetworks = createCySubNetworks(
  id = c(1,2),
  nodes = list("all", c(1,2,3)),
  edges = list("all", c(0,2))                    
)
rcx = updateCySubNetworks(rcx, cySubNetworks)

## add the network attributes
rcx = updateNetworkAttributes(rcx, networkAttributes1)

## add additional network attributes and update existing
rcx = updateNetworkAttributes(rcx, networkAttributes2)

## create a relation with a not existing subnetwork...
networkAttributes3 = createNetworkAttributes(
  name="X",
  value="new x",
  subnetworkId=9
)

## ...and try to add them
try(updateNetworkAttributes(rcx, networkAttributes3))
## =>ERROR: 
## NetworkAttributesAspect$subnetworkId IDs don't exist in CySubNetworksAspect
}
\seealso{
\code{\link{NetworkAttributes}}; \code{\link{NodeAttributes}}, \code{\link{EdgeAttributes}}
}
