% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-Cytoscape-VisualProperties.R
\name{updateCyVisualProperty}
\alias{updateCyVisualProperty}
\alias{updateCyVisualProperty.CyVisualPropertyProperties}
\alias{updateCyVisualProperty.CyVisualPropertyDependencies}
\alias{updateCyVisualProperty.CyVisualPropertyMappings}
\alias{updateCyVisualProperty.CyVisualProperty}
\title{Update Cytoscape Visual Property objects and sub-objects (used in CyVisualProperties aspect)}
\usage{
updateCyVisualProperty(
  cyVisualProperty,
  additionalProperty,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  .log = c()
)

\method{updateCyVisualProperty}{CyVisualPropertyProperties}(
  cyVisualProperty,
  additionalProperty,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  .log = c()
)

\method{updateCyVisualProperty}{CyVisualPropertyDependencies}(
  cyVisualProperty,
  additionalProperty,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  .log = c()
)

\method{updateCyVisualProperty}{CyVisualPropertyMappings}(
  cyVisualProperty,
  additionalProperty,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  .log = c()
)

\method{updateCyVisualProperty}{CyVisualProperty}(
  cyVisualProperty,
  additionalProperty,
  replace = TRUE,
  stopOnDuplicates = FALSE,
  .log = c()
)
}
\arguments{
\item{cyVisualProperty}{object; (to which it will be added)}

\item{additionalProperty}{object; (that will be added)}

\item{replace}{logical; if existing values are updated (or ignored)}

\item{stopOnDuplicates}{logical; whether to stop, if duplicates in \code{name} (and \code{subnetworkId} if present) column are found}

\item{.log}{character (optional); name of the calling function used in error logging}
}
\value{
\code{\link{CyVisualProperty}}, \code{\link{CyVisualPropertyProperties}}, \code{\link{CyVisualPropertyDependencies}} or
\code{\link{CyVisualPropertyMappings}} objects
}
\description{
This function is used to add Cytoscape visual property objects (\code{\link{CyVisualProperty}}) and its sub-objects
(\code{\link{CyVisualPropertyProperties}}, \code{\link{CyVisualPropertyDependencies}} and \code{\link{CyVisualPropertyMappings}}) to each other.
Cytoscape visual property objects define networks, nodes, edges, and default nodes and edges in a \code{\link{CyVisualProperties}} aspect.
}
\details{
\subsection{Structure of Cytoscape Visual Property}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{CyVisualProperty
|---properties = CyVisualPropertyProperties
|   |--name
|   |--value 
|---dependencies = CyVisualPropertyDependencies
|   |--name
|   |--value 
|---mappings = CyVisualPropertyMappings
|   |--name
|   |--type
|   |--definition 
|---appliesTo = <reference to subnetwork id>
|---view = <reference to subnetwork id>
}\if{html}{\out{</div>}}
}

\code{\link{CyVisualProperty}} objects differ in the sub-networks and views (\code{\link{CySubNetworks}}) they apply to,
subsequently properties, dependencies and mappings are merged based on the uniqueness in those two.

Properties, dependencies and mappings (i.e. \code{\link{CyVisualPropertyProperties}}, \code{\link{CyVisualPropertyDependencies}} and
\code{\link{CyVisualPropertyMappings}} objects) are unique in \code{name}.
By default, the duplicate attributes are updated with the values of the latest one.
This can prevented by setting the \emph{replace} parameter to \code{FALSE}, in that case only new attributes are added and
the existing attributes remain untouched.
Furthermore, if duplicated attributes are considered as a preventable mistake, an error can be raised by setting \emph{stopOnDuplicates}
to \code{TRUE}. This forces the function to stop and raise an error, if duplicated attributes are present.
}
\examples{
## Prepare used properties
## Visual property: Properties
vpPropertyP1 = createCyVisualPropertyProperties(c(NODE_BORDER_STROKE="SOLID"))
vpPropertyP2 = createCyVisualPropertyProperties(c(NODE_BORDER_WIDTH="1.5"))
vpPropertyP3 = createCyVisualPropertyProperties(c(NODE_BORDER_WIDTH="999"))

## Add two properties:
vpPropertyP4 = updateCyVisualProperty(vpPropertyP1,vpPropertyP2)
vpPropertyP4 = updateCyVisualProperty(vpPropertyP4,vpPropertyP3)

## Visual property: Dependencies
vpPropertyD1 = createCyVisualPropertyDependencies(c(nodeSizeLocked="false"))
vpPropertyD2 = createCyVisualPropertyDependencies(c(arrowColorMatchesEdge="true"))
vpPropertyD3 = createCyVisualPropertyDependencies(c(arrowColorMatchesEdge="false"))

## Add two dependencies:
vpPropertyD4 = updateCyVisualProperty(vpPropertyD1,vpPropertyD2)
vpPropertyD4 = updateCyVisualProperty(vpPropertyD4,vpPropertyD3)

## Visual property: Mappings
vpPropertyM1 = createCyVisualPropertyMappings(c(NODE_FILL_COLOR="CONTINUOUS"), 
                                              "COL=directed,T=boolean,K=0=true,V=0=ARROW")
vpPropertyM2 = createCyVisualPropertyMappings(c(EDGE_TARGET_ARROW_SHAPE="DISCRETE"), 
                                              "TRIANGLE")
vpPropertyM3 = createCyVisualPropertyMappings(c(EDGE_TARGET_ARROW_SHAPE="DISCRETE"), 
                                              "NONE")

## Add two mappings:
vpPropertyM4 = updateCyVisualProperty(vpPropertyM1,vpPropertyM2)
vpPropertyM4 = updateCyVisualProperty(vpPropertyM4,vpPropertyM3)

## Create visual property object 
vpProperty1 = createCyVisualProperty(properties=list(vpPropertyP1,
                                                     vpPropertyP1,
                                                     vpPropertyP1), 
                                     dependencies=list(vpPropertyD1,
                                                       vpPropertyD1,
                                                       NA), 
                                     mappings=list(vpPropertyM1,
                                                   NA,
                                                   vpPropertyM1),
                                     appliesTo = c(NA,
                                                   NA,
                                                   1),
                                     view = c(NA,
                                              1,
                                              NA))
vpProperty2 = createCyVisualProperty(properties=vpPropertyP2, 
                                     dependencies=vpPropertyD2, 
                                     mappings=vpPropertyM2)
vpProperty3 = createCyVisualProperty(properties=vpPropertyP3, 
                                     dependencies=vpPropertyD3, 
                                     mappings=vpPropertyM3)

## add two visual property objects
vpProperty4 = updateCyVisualProperty(vpProperty1, vpProperty2)

## update values
updateCyVisualProperty(vpProperty4, vpProperty3)

## keep old values
updateCyVisualProperty(vpProperty4, vpProperty3, 
                       replace = FALSE)

## keep old values
try(updateCyVisualProperty(vpProperty4, vpProperty3, 
                           stopOnDuplicates = TRUE))
## =>ERROR: 
## Elements of name (in properties<appliesTo=NA,view=NA>) must not contain duplicates!
}
\seealso{
\code{\link{getCyVisualProperty}}, \code{\link{updateCyVisualProperties}}
}
