% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AspectDependencies.R
\name{maxId}
\alias{maxId}
\alias{maxId.default}
\alias{maxId.RCX}
\title{Highest ID of an aspect}
\usage{
maxId(x)

\method{maxId}{default}(x)

\method{maxId}{RCX}(x)
}
\arguments{
\item{x}{an object of one of the aspect classes (e.g. NodesAspect, EdgesAspect, etc.) or \link[=RCX-object]{RCX} class.}
}
\value{
integer; Highest id. For \link[=RCX-object]{RCX} objects all highest ids are returned in the vector named by the aspect class.
}
\description{
This function returns the highest id used in an aspect, that has ids.
As example, the aspect \emph{NodesAspect} has the property \emph{id} that must be a unique positive integer.
}
\details{
Uses method dispatch, so the default return is \emph{NULL} and only aspect classes that have ids
are implemented. This way it is easier to extend the data model.
}
\examples{
nodes = createNodes(name = c("ĆDK1","CDK2","CDK3"))
maxId(nodes)
}
\seealso{
\code{\link[=hasIds]{hasIds()}}, \code{\link[=idProperty]{idProperty()}}, \code{\link[=refersTo]{refersTo()}}, \code{\link[=referredBy]{referredBy()}}, \code{\link[=maxId]{maxId()}}
}
