% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AspectDependencies.R
\name{hasIds}
\alias{hasIds}
\alias{hasIds.default}
\alias{hasIds.NodesAspect}
\alias{hasIds.EdgesAspect}
\alias{hasIds.CyGroupsAspect}
\alias{hasIds.CySubNetworksAspect}
\title{IDs of an aspect}
\usage{
hasIds(aspect)

\method{hasIds}{default}(aspect)

\method{hasIds}{NodesAspect}(aspect)

\method{hasIds}{EdgesAspect}(aspect)

\method{hasIds}{CyGroupsAspect}(aspect)

\method{hasIds}{CySubNetworksAspect}(aspect)
}
\arguments{
\item{aspect}{an object of one of the aspect classes (e.g. NodesAspect, EdgesAspect, etc.)}
}
\value{
logical
}
\description{
This function checks, if an aspect has IDs that may be referenced by other aspects.

By default aspects don't have IDs, so only the implemented classes have IDs.
Aspects with IDs will be considered in the meta-data aspect to determine properties like:
\emph{idCounter} and \emph{elementCount}.
}
\details{
Uses method dispatch, so the default return is \emph{FALSE} and only aspect classes with IDs are
implemented. This way it is easier to extend the data model.
}
\examples{
edges = createEdges(source = c(0,0), target = c(1,2))
hasIds(edges)
}
\seealso{
\code{\link[=idProperty]{idProperty()}}, \code{\link[=refersTo]{refersTo()}}, \code{\link[=referredBy]{referredBy()}}, \code{\link[=maxId]{maxId()}}
}
