% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils-error-handling.R
\name{.errorCodes}
\alias{.errorCodes}
\title{Error codes used in this package}
\usage{
.errorCodes(code, info = c("<info[1]>", "<info[2]>"))
}
\arguments{
\item{code}{character; Error code.}

\item{info}{character; Additional information used in some error codes.}
}
\value{
Full text for a given error code.
}
\description{
This function returns the error message to a given (internal) error code. For some codes, additional information for the message is needed.
}
\note{
Internal function only for convenience
}
\section{Details}{
 \subsection{List of error codes:}{
\subsection{ErrorCodeNotFound}{
\preformatted{
##############################
## !!ERROR CODE NOT FOUND!! ##
##############################
requested error code: 
<info[1]>}}
\subsection{e404}{
\preformatted{THIS ERROR SHOULD NEVER HAPPEN!!!}}
\subsection{graphNELEdgesRequired}{
\preformatted{RCX object requires edges to be converted to an graphNEL object!}}
\subsection{idNonNeg}{
\preformatted{Provided IDs (<info[1]>) must be non-neagtive!}}
\subsection{idNotNum}{
\preformatted{Provided IDs (<info[1]>) must be numeric!}}
\subsection{idRefNotFound}{
\preformatted{Provided IDs of <info[1]> don't exist in <info[2]>}}
\subsection{idRefNotPresent}{
\preformatted{<info[1]> not present as <info[2]>}}
\subsection{igraphEdgesRequired}{
\preformatted{RCX object requires edges to be converted to an igraph object!}}
\subsection{paramAllNull}{
\preformatted{At least one argument of <info[1]> must be set!}}
\subsection{paramDifferentLength}{
\preformatted{Arguments must have the same length!
  <info[1]>}}
\subsection{paramListAllWrongClass}{
\preformatted{Not all elements of the list <info[1]> are of class "<info[2]>"!}}
\subsection{paramMissing}{
\preformatted{Missing arguments: <info[1]>}}
\subsection{paramMissingRCX}{
\preformatted{RCX object is missing!}}
\subsection{paramNa}{
\preformatted{Argument <info[1]> must not contain any NA values!}}
\subsection{paramNonNeg}{
\preformatted{All elements of <info[1]> must be non-neagtive!}}
\subsection{paramNotChar}{
\preformatted{All elements of <info[1]> must be characters!}}
\subsection{paramNotList}{
\preformatted{Argument <info[1]> must be a list!}}
\subsection{paramNotLog}{
\preformatted{All elements of <info[1]> must be logical!}}
\subsection{paramNotNamed}{
\preformatted{Object <info[1]> must have names!}}
\subsection{paramNotNum}{
\preformatted{All elements of <info[1]> must be numeric!}}
\subsection{paramNotUnique}{
\preformatted{Elements of <info[1]> must not contain duplicates!}}
\subsection{paramWrongValue}{
\preformatted{Argument <info[1]> only can take following values: <info[2]>}}
\subsection{validationFail}{
\preformatted{Aspect (<info[1]>) failed validation!
Check if the aspect is valid: validate(<info[1]>)}}
\subsection{wrongClass}{
\preformatted{Class of object <info[1]> is not "<info[2]>"!}}
\subsection{wrongClassOf}{
\preformatted{Class of object <info[1]> is not one of <info[2]>!}}}
}

\keyword{internal}
