% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AspectDependencies.R
\name{countElements}
\alias{countElements}
\alias{countElements.default}
\alias{countElements.RCX}
\alias{countElements.CyVisualPropertiesAspect}
\alias{countElements.MetaDataAspect}
\title{Number of elements in aspect}
\usage{
countElements(x)

\method{countElements}{default}(x)

\method{countElements}{RCX}(x)

\method{countElements}{CyVisualPropertiesAspect}(x)

\method{countElements}{MetaDataAspect}(x)
}
\arguments{
\item{x}{an object of one of the aspect classes (e.g. \code{\link{Nodes}}) or \link[=RCX-object]{RCX} class.}
}
\value{
integer; number of elements. For RCX objects all counts are returned in the vector named by the aspect class.
}
\description{
This function returns the number of elements in an aspect.
}
\details{
Uses method dispatch, so the default methods already returns the correct number for the most aspect classes.
This way it is easier to extend the data model.

There are only two exceptions in the core and Cytoscape aspects: \code{\link{Meta-data}} and \code{\link{CyVisualProperties}}.

\code{\link{Meta-data}} is a meta-aspect and therefore not included in \code{\link{Meta-data}}, and so its return is \code{NA}.

\code{\link{CyVisualProperties}} is the only aspect with a complex data structure beneath.
Therefore its number of elements is just the number of how many of the following properties are set:
\code{network}, \code{nodes}, \code{edges}, \code{defaultNodes} or \code{defaultEdges}.
}
\examples{
nodes = createNodes(name = c("ĆDK1","CDK2","CDK3"))
edges = createEdges(source = c(0,0), target = c(1,2))
rcx = createRCX(nodes = nodes, edges = edges)

countElements(nodes)

countElements(rcx)
}
\seealso{
\code{\link[=hasIds]{hasIds()}}, \code{\link[=idProperty]{idProperty()}}, \code{\link[=refersTo]{refersTo()}}, \code{\link[=referredBy]{referredBy()}}, \code{\link[=maxId]{maxId()}}
}
