% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-Cytoscape-NetworkRelations.R
\name{CyNetworkRelations}
\alias{CyNetworkRelations}
\alias{createCyNetworkRelations}
\title{Cytoscape network relations}
\usage{
createCyNetworkRelations(child, parent = NULL, name = NULL, isView = FALSE)
}
\arguments{
\item{child}{integer; reference to \link[=CySubNetworks]{subnetwork id}}

\item{parent}{integer (optional); reference to \link[=CySubNetworks]{subnetwork id}, but left blank (or \code{NA}) for root-network}

\item{name}{character (optional); name of the subnetwork or view}

\item{isView}{logical (optional); \code{TRUE} for views, else the network defines a subnetwork}
}
\value{
\emph{CyNetworkRelationsAspect} object
}
\description{
This function is used to create Cytoscape network relations aspects.
}
\details{
Cytoscape contributes aspects that organize subnetworks, attribute tables, and visual attributes for use by its own layout and
analysis tools. Furthermore are the aspects used in web-based visualizations like within the NDEx platform.

Cytoscape network relations define the relationship between the main network, subnetworks and views and also a name can be
assigned to the relationship.
Both, subnetworks and views are defined as \link[=CySubNetworks]{subnetworks} aspect, but their type is defined here by the \emph{isView} property.
The parent of a subnetwork or view can be an other subnetwork or the root network.
}
\examples{
## a minimal example
cyNetworkRelations = createCyNetworkRelations(
  child = 1
)

## with all parameters
cyNetworkRelations = createCyNetworkRelations(
  child = c(1,2),
  parent = c(NA,1),
  name = c("Network A",
           "View A"),
  isView = c(FALSE, TRUE)
)

}
\seealso{
\code{\link{updateCyNetworkRelations}};
}
