% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AspectDependencies.R
\name{Convert-Names-and-Classes}
\alias{Convert-Names-and-Classes}
\alias{aspectName2Class}
\alias{aspectClass2Name}
\title{Convert aspect class name to RCX accession}
\usage{
aspectName2Class(name)

aspectClass2Name(cls)
}
\arguments{
\item{name}{character; name of the RCX accession of the Aspect}

\item{cls}{character; name of the aspect class}
}
\value{
accession or class name
}
\description{
The aspects in an RCX object are accessed by a \code{name} and return the aspect as an object of \code{cls}.
To simplify the conversion between those, these functions return the corresponding name.
}
\details{
The following accessions/classes are available within the standard RCX implementation:

\strong{accession name <=> class name}

\if{html}{\out{<div class="sourceCode rcx  <=>  RCX">}}\preformatted{metaData  <=>  MetaDataAspect
nodes  <=>  NodesAspect
edges  <=>  EdgesAspect
nodeAttributes  <=>  NodeAttributesAspect
edgeAttributes  <=>  EdgeAttributesAspect
networkAttributes  <=>  NetworkAttributesAspect
cartesianLayout  <=>  CartesianLayoutAspect
cyGroups  <=>  CyGroupsAspect
cyVisualProperties  <=>  CyVisualPropertiesAspect
cyHiddenAttributes  <=>  CyHiddenAttributesAspect
cyNetworkRelations  <=>  CyNetworkRelationsAspect
cySubNetworks  <=>  CySubNetworksAspect
cyTableColumn  <=>  CyTableColumnAspect```
}\if{html}{\out{</div>}}
}
\examples{
aspectName2Class("nodes")
##[1] "NodesAspect"

aspectClass2Name("NodesAspect")
##[1] "nodes"

aspectClasses

subAspectClasses
}
