% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-CartesianLayout.R
\name{CartesianLayout}
\alias{CartesianLayout}
\alias{createCartesianLayout}
\title{Cartesian layout}
\usage{
createCartesianLayout(node, x, y, z = NULL, view = NULL)
}
\arguments{
\item{node}{integer; reference to \link[=Nodes]{node ids}}

\item{x}{numeric; x coordinate}

\item{y}{numeric; y coordinate}

\item{z}{numeric (optional); z coordinate}

\item{view}{integer (optional); reference to \link[=CySubNetworks]{subnetwork id} of type view (\code{\link{CyNetworkRelations}})}
}
\value{
\emph{CartesianLayoutAspect} object
}
\description{
This function creates a cartesian layout aspect, that stores coordinates of nodes.
}
\details{
The layout of networks can be influenced by setting the \link[=Nodes]{node} position manually.
While x an y coordinates are mandatory, the z coordinates are optional and can, for example, be used to define the vertical stacking order
of overlapping nodes.

Similar to Cytoscape \url{https://cytoscape.org/}, it is possible to define different views of the same network.
The views itself are definded in \code{\link{CySubNetworks}} and \code{\link{CyNetworkRelations}}, and only referenced by a unique
subnetwork id.
}
\examples{
## a minimal example
cartesianLayout = createCartesianLayout(
  node=0,
  x=5.5, 
  y=200.3
)

## defining several coordinates at once
cartesianLayout = createCartesianLayout(
  node=c(0, 1),
  x=c(5.5, 110.1), 
  y=c(200.3, 210.2)
)

## with all parameters
cartesianLayout = createCartesianLayout(
  node=c(0, 1, 0),
  x=c(5.5, 110.1, 7.2), 
  y=c(200.3, 210.2, 13.9),
  z=c(-1, 3.1, NA),
  view=c(NA, NA, 1476)
)
}
\seealso{
\code{\link{updateCartesianLayout}};
}
