% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{getLineage}
\alias{getLineage}
\title{Infer the development lineage based on the clustering results from RCSL and the pseudotime}
\usage{
getLineage(drData, clustRes, pseudoTime, simMeasure = "kendall")
}
\arguments{
\item{drData}{preprocessed gene expression data (each column represent a cell)}

\item{clustRes}{the clustering results identified by RCSL}

\item{pseudoTime}{inferred by PlotPseudoTime() using the similarity matrix S and starting cell}

\item{simMeasure}{the calculation method of measuring the cluster centers' similarity}
}
\value{
lineage the cell lineages connected all the cluster centers based on the clustering results from RCSL
}
\description{
Infer the development lineage based on the clustering results from RCSL and the pseudotime
}
\examples{
gfData <- GenesFilter(yan)
TrueLabel <- ann$cell_type1
res_SimS <- SimS(gfData)
C <- EstClusters(res_SimS$drData,res_SimS$S)
res_BDSM <- BDSM(res_SimS$S,C)
Pseudo <- PlotPseudoTime(res_SimS$S,TrueLabel,startPoint=1)
getLineage(res_SimS$drData,res_BDSM$y,Pseudo$pseudoTime)

}
