% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{TrajectoryAnalysis}
\alias{TrajectoryAnalysis}
\title{Trajectory analysis}
\usage{
TrajectoryAnalysis(
  gfData,
  drData,
  S,
  clustRes,
  fontSize = 12,
  TrueLabel,
  startPoint,
  dataName = "",
  sim = TRUE,
  simMeasure = "kendall",
  VisualMethod = "umap"
)
}
\arguments{
\item{gfData}{preprocessed gene expression data (each column represent a cell)}

\item{drData}{preprocessed gene expression data (each column represent a cell)}

\item{S}{the similarity matrix calculated by SimS() function}

\item{clustRes}{the clustering results identified by RCSL}

\item{fontSize}{the size of font in the plot}

\item{TrueLabel}{the real cell types used to indicate the vertical axis}

\item{startPoint}{the posiition of the starting cell in the matrix}

\item{dataName}{the name of the data that will be showed in the plot}

\item{sim}{indicate the input data is simialrity matrix or not}

\item{simMeasure}{the calculation method of measuring the cluster centers' similarity}

\item{VisualMethod}{the display method of 2-D visualization}
}
\value{
PseudoTimePlot, MSTPlot, TrajectoryPlot
}
\description{
Trajectory analysis
}
\examples{
gfData <- GenesFilter(yan)
TrueLabel <- ann$cell_type1
res_SimS <- SimS(gfData)
C <- EstClusters(res_SimS$drData,res_SimS$S)
res_BDSM <- BDSM(res_SimS$S,C)
TrajectoryAnalysis(gfData,res_SimS$drData,res_SimS$S,res_BDSM$y,
                   TrueLabel=TrueLabel,startPoint=1)

}
