% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_getDevianceRes.R
\name{getDevianceRes}
\alias{getDevianceRes}
\title{A function to calculate the matrix of deviance residuals.}
\usage{
getDevianceRes(RCM, Dim = RCM$k)
}
\arguments{
\item{RCM}{an RCM object}

\item{Dim}{The dimensions to use

For the deviance residuals we use the overdispersions from the reduced model.
Standard dimensions used are only first and second,
 since these are also plotted}
}
\value{
A matrix with deviance residuals of the same size
as the original data matrix
}
\description{
A function to calculate the matrix of deviance residuals.
}
\examples{
data(Zeller)
require(phyloseq)
tmpPhy = prune_taxa(taxa_names(Zeller)[1:120],
prune_samples(sample_names(Zeller)[1:75], Zeller))
#Subset for a quick fit
zellerRCM = RCM(tmpPhy, k = 2, round = TRUE, prevCutOff = 0.03)
devRes = getDevianceRes(zellerRCM)
}
