% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_estNBparams.R
\name{estNBparams}
\alias{estNBparams}
\title{A function to estimate the taxon-wise NB-params}
\usage{
estNBparams(
  design,
  thetas,
  muMarg,
  psi,
  X,
  nleqslv.control,
  ncols,
  initParam,
  v,
  dynamic = FALSE,
  envRange,
  allowMissingness,
  naId
)
}
\arguments{
\item{design}{an n-by-v design matrix}

\item{thetas}{a vector of dispersion parameters of length p}

\item{muMarg}{an offset matrix}

\item{psi}{a scalar, the importance parameter}

\item{X}{the data matrix}

\item{nleqslv.control}{a list of control elements, passed on to nleqslv()}

\item{ncols}{an integer, the number of columns of X}

\item{initParam}{a v-by-p matrix of initial parameter estimates}

\item{v}{an integer, the number of parameters per taxon}

\item{dynamic}{a boolean, should response function be determined dynamically?
See details}

\item{envRange}{a vector of length 2, giving the range of observed
environmental scores}

\item{allowMissingness}{A boolean, are missing values present}

\item{naId}{The numeric index of the missing values in X

If dynamic is TRUE, quadratic response functions are fitted for every taxon.
If the optimum falls outside of the observed range of environmental scores,
a linear response function is fitted instead}
}
\value{
a v-by-p matrix of parameters of the response function
}
\description{
A function to estimate the taxon-wise NB-params
}
