% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_dNBllcol.R
\name{dNBllcolOld}
\alias{dNBllcolOld}
\title{A score function for the estimation of the column scores
in an unconstrained RC(M) model}
\usage{
dNBllcolOld(
  beta,
  X,
  reg,
  thetas,
  muMarg,
  k,
  p,
  n,
  colWeights,
  nLambda,
  cMatK,
  allowMissingness,
  naId,
  ...
)
}
\arguments{
\item{beta}{vector of length p+1+1+(k-1): p row scores,
1 centering, one normalization and (k-1) orhtogonality lagrangian multipliers}

\item{X}{the nxp data matrix}

\item{reg}{a nx1 regressor matrix: outer product of rowScores and psis}

\item{thetas}{nxp matrix with the dispersion parameters
(converted to matrix for numeric reasons)}

\item{muMarg}{the nxp offset}

\item{k}{an integer, the dimension of the RC solution}

\item{p}{an integer, the number of taxa}

\item{n}{an integer, the number of samples}

\item{colWeights}{the weights used for the restrictions}

\item{nLambda}{an integer, the number of restrictions}

\item{cMatK}{the lower dimensions of the colScores}

\item{allowMissingness}{A boolean, are missing values present}

\item{naId}{The numeric index of the missing values in X}

\item{...}{further arguments passed on to the jacobian}
}
\value{
A vector of length p+1+1+(k-1) with evaluations of the
 derivative of lagrangian
}
\description{
A score function for the estimation of the column scores
in an unconstrained RC(M) model
}
